# Indexer

(Crate name: dexr)

A directory indexer with thumbnails, previews, and slideshow functionality.

It's meant to be a faster and more lightweight version of Lars Jung's H5AI.

## Features

`*` = requires JS

- Basic page fully server-side rendered
- Minimal interface without excessive styling
  - Effort made to be as accessible as possible (please email me if you see anything that can be improved!)
  - Can easily be re-themed using CSS variables
  - Dark mode included using `@media (prefers-color-scheme: dark)`
- Thumbnails for most images and videos
  - Cached in a configurable temporary directory
- \*Sorting
- \*In-page previews for images and videos
  - Supports keyboard-based usage: left and right arrows, Home, End
- \*Slideshow
  - Activated via keyboard (`s`) or mouse (double click on next button)
  - Custom interval

## Configuration

Configuration is placed in a file called `dexr.toml` in the working directory of the executable, and can also be specified with environment variables.

The environment variables are named `DEXR_<SCREAMING_SNAKE_CASE_KEY>`, so for example the `address` field would be `DEXR_ADDRESS`. If a key is specified in both locations, the environment variable takes precedence.

The following keys can be used to configure the indexer:

| Key                | Type      | Default     | Meaning                                                                   | Example/Possible Values  |
| ------------------ | --------- | ----------- | ------------------------------------------------------------------------- | ------------------------ |
| `address`          | See below | None        | The address for the server to listen on                                   | `"tcp://127.0.0.1:3000"` |
| `index_root`       | Path      | None        | The directory that will be indexed                                        | `"/srv/my-public-files"` |
| `thumbnail_tmp`    | Path      | None        | The location of the thumbnail cache                                       | `"/tmp/dexr-thumbnails"` |
| `directory_size`   | See below | `"entries"` | How sizes are calculated for directories                                  | `"no_size"`              |
| `exclude_dotfiles` | Boolean   | `true`      | Whether to hide dotfiles in indexes, and return 404 if accessed as a file | `true`                   |

### `address` format

The address can be a TCP address or a Unix socket path. A TCP address is in the format `tcp://<host>:<port>`, like `tcp://127.0.0.1:3000`. A Unix socket is in the format `unix://<path to socket>`, like `unix:///tmp/indexer/socket.sock`. If no protocol prefix (`<protocol>://`) is specified, as in `localhost:3000`, it defaults to a TCP address.

### `directory_size` possible values

| Name                  | Meaning                                                                          | Relative Speed |
| --------------------- | -------------------------------------------------------------------------------- | -------------- |
| `"no_size"`           | Don't show any size at all for directories.                                      | Fast           |
| `"entries"` (default) | Show the number of entries for the size.                                         | Medium         |
| `"naive"`             | Use the size returned by the operating system, which is not the number of items. | Fast           |
| `"recursive"`         | Calculate the size by traversing all items in the directory recursively.         | Slow           |

## Installation

A typical Rust package can be installed with `cargo install <package name>`. However, this project has some additional system requirements. You will need GStreamer as a build-time requirement, as well as as many GST plugins as you are able to install at runtime for maximum video thumbnail support. On Arch Linux, those would be `gst-plugins-{good,bad,ugly}` and `gst-libav`.

Following is an example SystemD service to run the indexer.

```toml
[Unit]
Description=Directory Indexer
Before=nginx.service # remove if not using a reverse proxy

[Service]
PrivateDevices=true
ProtectControlGroups=true
ProtectHome=true
ProtectKernelTunables=true
ProtectSystem=full
RestrictSUIDSGID=true
DynamicUser=true
WorkingDirectory=/opt/dexr
RuntimeDirectory=dexr
CacheDirectory=dexr_thumbnails
ExecStart=/opt/dexr/dexr

[Install]
WantedBy=multi-user.target
```

This installation was created as follows:

1. Create the installation directory, `/opt/dexr`.
1. Copy the binary to `/opt/dexr/dexr`.
1. Create the `/opt/dexr/dexr.toml` configuration file and add your configuration, ensuring that all the required keys (those with no default) are specified. Make sure to also merge the following configuration into it once you're done:

```toml
address = "unix:///run/dexr/socket.sock"
thumbnail_tmp = "/var/cache/dexr_thumbnails"
```

Now the service will be listening on that Unix socket. (The socket can be named whatever you want within `/run/dexr`.)
