use rocket::http::ContentType;
use rocket::response::{Responder, Result};
use rocket::{get, Request};

#[get("/css/index.css")]
pub fn css() -> TypedByteSlice<'static> {
	TypedByteSlice {
		ty: ContentType::CSS,
		data: std::include_bytes!("../static/index.css").as_slice(),
	}
}

#[get("/js/index.js")]
pub fn js() -> TypedByteSlice<'static> {
	TypedByteSlice {
		ty: ContentType::JavaScript,
		data: include_bytes!("../static/index.js").as_slice(),
	}
}

pub struct TypedByteSlice<'a> {
	ty: ContentType,
	data: &'a [u8],
}

impl<'r, 'o: 'r> Responder<'r, 'o> for TypedByteSlice<'o> {
	fn respond_to(self, request: &'r Request<'_>) -> Result<'o> {
		self.data.respond_to(request).map(move |mut req| {
			req.set_header(self.ty);
			req
		})
	}
}
