use crate::config::Config;
use handlebars::Handlebars;
use rocket::http::ContentType;
use rocket::http::Status as HttpStatus;
use rocket::response::content::Custom as CustomType;
use rocket::{get, State};
use std::path::PathBuf;
use std::sync::Arc;

mod builder;
mod context;
mod entry;

#[get("/<path..>", rank = 12)]
pub async fn index_wrapper(path: PathBuf, config: &State<Arc<Config>>, hbs: &State<Handlebars<'static>>) -> Result<CustomType<String>, HttpStatus> {
	let config = (*config).clone();
	let context = rocket::tokio::task::spawn_blocking(move || builder::Builder::new(&path, &config).build()).await.unwrap()?;
	Ok(CustomType(ContentType::HTML, hbs.render("index.html", &context).map_err(crate::util::handlebars_error_to_status)?))
}
