# Indexer

(Crate name: dexr)

A directory indexer with thumbnails, previews, and slideshow functionality.

It's meant to be a faster and more lightweight version of Lars Jung's H5AI.

## Features

`*` = requires JS

- Basic page fully server-side rendered
- Minimal interface without excessive styling
  - Effort made to be as accessible as possible (please email me if you see anything that can be improved!)
  - Can easily be re-themed using CSS variables
  - Dark mode included using `@media (prefers-color-scheme: dark)`
- Thumbnails for most images and videos
  - Cached in a configurable temporary directory
- \*Sorting
- \*In-page previews for images and videos
  - Supports keyboard-based usage: left and right arrows, Home, End
- \*Slideshow
  - Activated via keyboard (`s`) or mouse (double click on next button)
  - Custom interval

## Configuration

Configuration is placed in a file called `Rocket.toml` in the working directory of the executable.

In addition to the keys provided by Rocket, which are documented at <https://rocket.rs/v0.5-rc/guide/configuration/>, the following keys can be used to configure the indexer. These keys are placed in the `[default]` section of the configuration file.

| Key                | Type      | Default     | Meaning                                                                   | Example/Possible Values                            | Notes                                                                                                                                         |
| ------------------ | --------- | ----------- | ------------------------------------------------------------------------- | -------------------------------------------------- | --------------------------------------------------------------------------------------------------------------------------------------------- |
| `index_root`       | Path      | None        | The directory that will be indexed                                        | `"/srv/my-public-files"`                           |                                                                                                                                               |
| `thumbnail_tmp`    | Path      | None        | The location of the thumbnail cache                                       | `"/tmp/dexr-thumbnails"`                           | If you have a lot of files and not much memory, it may be wiser to store the thumbnails on disk, for example in `"/var/tmp/dexr-thumbnails"`. |
| `directory_size`   | See below | `"entries"` | How sizes are calculated for directories                                  | `"no_size"`                                        | See below                                                                                                                                     |
| `exclude_dotfiles` | Boolean   | `true`      | Whether to hide dotfiles in indexes, and return 404 if accessed as a file | Files starting with `.` are conventionally hidden. |

### `directory_size` possible values

| Name                  | Meaning                                                                                                                                                                          | Relative Speed |
| --------------------- | -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | -------------- |
| `"no_size"`           | Don't show any size at all for directories.                                                                                                                                      | Fast           |
| `"entries"` (default) | Show the number of entries for the size.                                                                                                                                         | Medium         |
| `"naive"`             | Use the size returned by the operating system, which is usually the block size of the directory and is not related to the number of items. This mainly exists for compatibility. | Fast           |
| `"recursive"`         | Calculate the size by traversing all items in the directory recursively.                                                                                                         | Slow           |
