use rocket::fs::{FileServer, Options as FSOptions};
use rocket::response::Redirect;
use rocket::{get, routes, Build, Rocket};
use rocket_dyn_templates::Template;
use std::sync::Arc;

mod config;
mod index;
mod thumbnail;
mod util;

use config::Config;

#[rocket::main]
async fn main() -> anyhow::Result<()> {
	Ok(rocket()?.launch().await?)
}

fn rocket() -> anyhow::Result<Rocket<Build>> {
	let rocket = rocket::build();

	let config = rocket.figment().extract::<Config>()?;
	let config = Arc::new(config);

	let rocket = rocket
		.manage(config.clone())
		.attach(Template::custom(|engines| engines.handlebars.set_strict_mode(true)))
		.mount("/static", FileServer::new("public", FSOptions::Index))
		.mount(
			"/fs",
			FileServer::new(&config.index_root, {
				let exclude_dotfiles = if config.exclude_dotfiles { FSOptions::None } else { FSOptions::DotFiles };
				FSOptions::NormalizeDirs | exclude_dotfiles
			}),
		)
		.mount("/fs", routes![index::index_wrapper])
		.mount("/thumbnail", routes![thumbnail::thumbnail_wrapper])
		.mount("/", routes![root]);
	Ok(rocket)
}

#[get("/")]
fn root() -> Redirect {
	Redirect::permanent("/fs")
}
