use crate::config::Config;
use rocket::http::Status as HttpStatus;
use rocket::{get, State};
use rocket_dyn_templates::Template;
use std::path::PathBuf;
use std::sync::Arc;

mod builder;
mod context;
mod entry;

#[get("/<path..>", rank = 12)]
pub async fn index_wrapper(path: PathBuf, config: &State<Arc<Config>>) -> Result<Template, HttpStatus> {
	let config = (*config).clone();
	let context = rocket::tokio::task::spawn_blocking(move || builder::Builder::new(&path, &config).build()).await.unwrap()?;
	Ok(Template::render("index", context))
}
