use serde::Deserialize;
use std::path::PathBuf;

#[derive(Deserialize)]
pub struct Config {
	pub index_root: PathBuf,
	pub thumbnail_tmp: PathBuf,
	#[serde(default)]
	pub directory_size: DirectorySizeOption,
	#[serde(default = "default_exclude_dotfiles")]
	pub exclude_dotfiles: bool,
}

const fn default_exclude_dotfiles() -> bool {
	true
}

#[derive(Deserialize, Clone, Copy, PartialEq, Eq)]
#[serde(rename_all = "snake_case")]
pub enum DirectorySizeOption {
	/// Don't show the size of directories at all
	NoSize,
	/// Show the size of directories as the number of entries (subdirectories/files)
	Entries,
	/// Use the "size" returned by the operating system, which is not representative of the contents of the directory
	Naive,
	/// Determine the size of the directory by recursing into subdirectories. Can be very slow.
	Recursive,
}

impl Default for DirectorySizeOption {
	fn default() -> Self {
		Self::Entries
	}
}
