use std::io::{self, BufRead};
use std::collections::HashSet;

fn main() {
    let stdin = io::stdin();

    for line in stdin.lock().lines() {
        println!("{}", devowel(line.unwrap().as_str()));
    }
}

pub fn devowel(s: &str) -> String {
    let mut out = String::new();

    let vwls = HashSet::from(['a', 'e', 'i', 'o', 'u']);

    for c in s.chars() {
        if !vwls.contains(&c) {
            out.push(c);
        }
    }

    out
}
