# NQueens Solver

## Find one solution in O(1)

```rust
#[test]
fn find_solution() {
    for i in 0..=8 {
        match NQueens::solve(i) {
            None => println!("Rank {} has no solution", i),
            Some(s) => println!("\n{}", s),
        }
    }
}
```


## Find first 4 solution of rank 5

```rust
#[test]
fn find_partial() {
    for (i, s) in NQueens::solve_all(5).enumerate().take(4) {
        println!("Solution #{}:", i + 1);
        println!("{}", s);
    }
}
```

## Find next solution by lexicographical order

```rust
#[test]
fn find_next() {
    let s1 = NQueens::solve(5).unwrap();
    let s2 = NQueens::solve_next(s1).unwrap();
    println!("Solution #2:");
    println!("{}", s2);
}
```
