# Desk

### 🔮 The application platform for your cyberpunk desk. 🔮

[![Demo](https://img.shields.io/badge/Desk--X-Wasm+WebGL2-grey?labelColor=b236a6)](https://desk-x.com)
[![GitHub Sponsors](https://img.shields.io/github/sponsors/ryo33?color=ffc5cd&labelColor=2a4638)](https://github.com/sponsors/ryo33)
[![MIT/Apache 2.0](https://img.shields.io/badge/license-MIT%2FApache--2.0-blue.svg?style=flat)](https://github.com/Hihaheho/Desk/blob/main/LICENSE)
[![GitHub Repo stars](https://img.shields.io/github/stars/Hihaheho/Desk?style=social&color=yellow)](https://github.com/Hihaheho/Desk)
[![Discord](https://img.shields.io/discord/808315755460165683?color=6A7EC2&label=&logo=discord&logoColor=ffffff&labelColor=4e5af0&style=flat)](https://discord.gg/egTTeg7DRp)

## Goal and philosophy

🎯 **We want to make top boards of people's desks into touch panel displays that run Desk.**

- 🎮 **Intuitive** like games
- 🥼 **Pragmatic** like professional tools
- 🗺️️ **Versatile** like spreadsheet
- 💗 **Accessible** to everyone
- 🛹 **Minimalist** design

## Why Desk?

Desk apps (applications built on Desk) are inherently:

- 🎼 **Data-oriented**
- 🔒 **Statically-typed** (data and UI)
- 🤖 **Programmable** (extensible by code)
- 🧲 **Interoperable** with other Desk apps
- 📱 Running on **everywhere** (web, desktop, mobile)

## How does it work?

Desk is powered by *Desk Programming Language* and *Desk Kernel*.

### Desk Programming Language

Desk programming language (Desk-lang) is a programming language which has:

- Minimalistic syntax and semantics
- Type system with inference
- Algebraic effects
- Content-addressable by type and UUID
- Embeddable interpreter
- 🚧 Compiler for performant binary

🚧 not yet implemented

Any data and programs on Desk apps are finally evaluated as snippets of Desk-lang.

### Desk Kernel

Desk kernel (Dkernel) is a platform-agnostic environment for writing and running Desk-lang. Functionalities and UIs of Desk apps are made up by syscall of Dkernel.

Dkernel provides these features:

- 🚧 File system for Desk-lang
- 🚧 Type-driven UI components
- 🚧 Incremental computation engine
- 🚧 Realtime collaboration support
- 🚧 Package management system
- 🚧 Version control system
- 🚧 Permission management system
- 🚧 3D/2D rendering with meshes

🚧 not yet implemented

## Is it any good?

Yes.

## Resources

- [Visualized codebase](https://mango-dune-07a8b7110.1.azurestaticapps.net/?repo=Hihaheho%2FDesk)

## Join our community

👉 [![Q&A Have a question?](https://img.shields.io/badge/Q%26A-Have%20a%20question%3F-yellowgreen?style=social&logo=github)](https://github.com/Hihaheho/Desk/discussions/new?category=q-a)

👉 [![GitHub Discussions](https://img.shields.io/github/discussions/Hihaheho/Desk?logo=GitHub&style=social)](https://github.com/Hihaheho/Desk/discussions)

👉 [![GitHub Repo stars](https://img.shields.io/github/stars/Hihaheho/Desk?style=social)](https://github.com/Hihaheho/Desk)

👉 [![Twitter Follow](https://img.shields.io/twitter/follow/HihahehoStudio?style=social)](https://twitter.com/HihahehoStudio)

👉 [![Discord](https://img.shields.io/discord/808315755460165683?color=6A7EC2&label=&logo=discord&logoColor=ffffff&labelColor=4e5af0&style=for-the-badge)](https://discord.gg/egTTeg7DRp)
