//! # desfire
//!
//! **WARNING** This is alpha quality software at best and should not be relied upon. **WARNING**
//!
//!The `desfire` Crate provides the cryptographic methods and specific commands for interfacing
//! with NXP MiFare Desfire cards. 
//!

use crate::iso7816_4::apducommand::APDUCommand;
use crate::iso7816_4::apduresponse::APDUResponse;
use error::Result;

pub mod crypto;
pub mod desfire;
pub mod error;
pub mod iso7816_4;

pub trait Card {
    /// <summary>
    /// Connect to Smartcard
    /// </summary>
    fn connect(&mut self) -> Result<()>;

    /// <summary>
    /// Disconnect from Smartcard
    /// </summary>
    fn disconnect(&mut self) -> Result<()>;

    /// <summary>
    /// Transmit APDU Command to Smartcard
    /// </summary>
    /// <param name="apdu_cmd">Application Protocol Data Unit Command - ISO 7816</param>
    /// <returns>Application Protocol Data Unit Response - ISO 7816</returns>
    fn transmit(&self, apdu_cmd: APDUCommand) -> Result<APDUResponse>;
}

