#[repr(u16)]
pub enum APDUStatusCodes {
    /// Successful operation
    OPERATION_OK = 0x9000,

    /// No changes done to backup files, CommitTransaction / AbortTransaction not necessary
    NO_CHANGES = 0x900C,

    /// Insufficient NV-Memory to complete command
    OUT_OF_EEPROM_ERROR = 0x900E,

    /// Command code not supported
    ILLEGAL_COMMAND_CODE = 0x901C,

    /// CRC or MAC does not match data Padding bytes not valid
    INTEGRITY_ERROR = 0x901E,

    /// Invalid key number specified
    NO_SUCH_KEY = 0x9040,

    /// Invalid key number specified
    LENGTH_ERROR = 0x907E,

    /// Current configuration / status does not allow the requested command
    PERMISSION_DENIED = 0x909D,

    /// Value of the parameter(s) invalid
    PARAMETER_ERROR = 0x909E,

    /// Requested AID not present on PICC
    APPLICATION_NOT_FOUND = 0x90A0,

    /// Unrecoverable error within application, application will be disabled
    APPL_INTEGRITY_ERROR = 0x90A1,

    /// Current authentication status does not allow the requested command
    AUTHENTICATION_ERROR = 0x90AE,

    /// Additional data frame is expected to be sent
    ADDITIONAL_FRAME = 0x90AF,

    /// Attempt to read/write data from/to beyond the file\'s/record\'s limits. Attempt to exceed the limits of a value file.
    BOUNDARY_ERROR = 0x90BE,

    /// Unrecoverable error within PICC, PICC will be disabled
    PICC_INTEGRITY_ERROR = 0x90C1,

    /// Previous Command was not fully completed Not all Frames were requested or provided by the PCD
    COMMAND_ABORTED = 0x90CA,

    /// PICC was disabled by an unrecoverable error
    PICC_DISABLED_ERROR = 0x90CD,

    /// Number of Applications limited to 28, no additional CreateApplication possible
    COUNT_ERROR = 0x90CE,

    /// Creation of file/application failed because file/application with same number already exists
    DUPLICATE_ERROR = 0x90DE,

    /// Could not complete NV-write operation due to loss of power, internal backup/rollback mechanism activated
    EEPROM_ERROR = 0x90EE,

    /// Specified file number does not exist
    FILE_NOT_FOUND = 0x90F0,

    /// Unrecoverable error within file, file will be disabled
    FILE_INTEGRITY_ERROR = 0x90F1,
}
