use desdemona::Position;

fn main() {
    println!("// GENERATED BY bin/desdata; do not modify by hand!");

    generate_static_index_lines();
}

fn generate_static_index_lines() {
    print!("pub const POSITION_INDEX_LINES: &[&[&[usize]]] = ");
    print!("&[");
    for idx in 0..64 {
        let p = Position::new(idx);
        let p_lines: Vec<Vec<usize>> = vec![
            p.generate_north(),
            p.generate_north_east(),
            p.generate_east(),
            p.generate_south_east(),
            p.generate_south(),
            p.generate_south_west(),
            p.generate_west(),
            p.generate_north_west(),
        ]
        .into_iter()
        .filter(|ps| ps.len() > 1)
        .map(|ps| ps.into_iter().map(|p| p.into()).collect::<Vec<usize>>())
        .collect();

        print!("&[");
        for line in p_lines {
            print!("&{:?},", line)
        }
        print!("],");
    }
    println!("];");
}
