#[allow(unused_imports)]
#[allow(unused_macros)]
#[cfg(feature = "diesel-id")]
#[macro_use]
pub extern crate diesel;

#[cfg(feature = "diesel-id")]
#[macro_use]
pub extern crate diesel_derive_newtype;

pub extern crate serde;

pub extern crate derive_more;

#[macro_export]
macro_rules! derive_id {
	($id_newtype:item) => {
		#[cfg_attr(feature = "graphql", derive(async_graphql::NewType))]
		#[cfg_attr(
			not(feature = "graphql"),
			derive($crate::derive_more::From, $crate::derive_more::Into)
		)]
		#[cfg_attr(
			feature = "diesel-id",
			derive($crate::diesel_derive_newtype::DieselNewType)
		)]
		#[cfg_attr(feature = "diesel-id", derive(Identifiable))]
		#[derive(
			$crate::derive_more::Display,
			$crate::serde::Deserialize,
			$crate::serde::Serialize,
			Clone,
			Copy,
			Debug,
			Eq,
			Hash,
			Ord,
			PartialEq,
			PartialOrd,
		)]
		$id_newtype
	};
}

#[cfg(test)]
mod tests {
	table! {

			content (id) {
					id -> Int4,
					title -> Varchar,
			}
	}

	table! {

			users (id) {
					id -> Int4,
					name -> Varchar,
			}
	}

	table! {

			users_content (user_id, content_id) {
					user_id -> Int4,
					content_id -> Int4,
			}
	}

	derive_id! {
		#[table_name = "users"]
		#[graphql(name = "UserID")]
		pub struct UserId(#[column_name = "id"] i32);
	}

	derive_id! {
		#[table_name = "content"]
		#[graphql(name = "ContentID")]
		pub struct ContentId(#[column_name = "id"] i32);
	}
}
