use crate::Config;
use eyre::{Context, Result};
use rayon::prelude::*;
use std::io::{self, Write};
use std::path::Path;

pub fn purge() -> Result<()> {
    print!("Do you really want to purge all repositories, including potetnial changes that are not pushed? [yes/no] ");
    io::stdout().flush()?;
    let answer: String = text_io::read!();
    if answer == "yes" {
        let config: Config = toml::from_str(&std::fs::read_to_string("deployah.toml")?)?;

        match &config.repos {
            None => println!("No repositories specified"),
            Some(repos) => repos.par_iter().try_for_each(|repo_config| {
                std::fs::remove_dir_all(Path::new(&repo_config.name))
                    .with_context(|| format!("Could not delete repostiroy '{}'", repo_config.name))
            })?,
        }
    }

    Ok(())
}
