use crate::Config;
use eyre::{Context, Result};
use rayon::prelude::*;

pub fn update() -> Result<()> {
    let config: Config = toml::from_str(&std::fs::read_to_string("deployah.toml")?)?;

    match &config.repos {
        None => println!("No repositories specified"),
        Some(repos) => {
            repos.par_iter().try_for_each(|repo_config| {
                println!("Checking repository '{}'", repo_config.name);
                crate::tool::git::apply(repo_config).context("Could not apply")
            })?;
        }
    }
    Ok(())
}
