use serde::{Deserialize, Serialize};

pub mod subcommand;
pub mod tool;

#[derive(Serialize, Deserialize, Debug)]
pub struct Config {
    pub title: String,
    pub name: String,
    pub repos: Option<Vec<Repo>>,
}

impl Config {
    pub fn add(&mut self, name: &str, url: &str, branch: &str) {
        let repo = Repo {
            name: name.to_string(),
            url: url.to_string(),
            branch: branch.to_string(),
        };

        self.repos.get_or_insert(vec![]).push(repo);
    }
}

#[derive(Serialize, Deserialize, Debug)]
pub struct Repo {
    pub name: String,
    pub url: String,
    pub branch: String,
}

#[derive(Serialize, Deserialize, Debug)]
pub struct PyProject {
    pub installah: Option<Installah>,
}

#[derive(Serialize, Deserialize, Debug)]
pub struct Installah {
    pub service: Option<Service>,
    pub cp: Option<Vec<CopyItem>>,
}

#[derive(Serialize, Deserialize, Debug)]
pub struct Service {
    pub template: String,
    pub instance: Vec<String>,
}

#[derive(Serialize, Deserialize, Debug)]
pub struct CopyItem {
    pub src: String,
    pub dest: String,
}

pub enum DirType {
    Deployah,
    PyProject,
    None,
}
