# Deployah

Deployah is a tool to deploy software systems in a very specific context:

* the system consits of multiple repositories
    * which are using the git VCS
    * that are not dependent on each other on a source code level
    * but work together as a systems
* the system runs on Linux
    * and needs access to the hardware
    * is not using containers
* the system needs to be tested on target hardware
* the system will also be occasionally developed on the tagert hardware

## Workflow

Deployah aims to simplify your life if you are in the specific situation described above.

It starts with a new deployah directory on your target machine, which itself can be version controlled via git or similar.

`mkdir myprojectdeployment`

Deployah uses a `deploay.toml` file to control your deployahment.

You can creat one using the command:  `deployah init`.

This will create a file with this content:

```
title = ""
name = ""
```

You can now manually set the title for the deployah file and the project name. Alternativley, you could also use tha above command with flags: `deployah init --title="file title" --name="project name"`.

Now you can add a repository: `deployah add`.

This will change the file to:

```
title = "file title"
name = "project name"

[[repos]]
name = ""
url = ""
branch = ""
```

Again, you can manually set the values or use the command with flags.
The easiest way is propably to set up the file with `init` and `add` and then modify the file manually.

You can copy-paste the `[[repos]]` section to add more repos. The `name` is the name of the directory the repo will be cloned into, the `url` is the address of the git repository (you can get it i.e. from GitLabs `Clone` button) and `branch` is the branch you want.

Once you set up your `deployah.toml` you can get all the repositories by running `deployah update`. The same command will update your repositories by fetching the latest changes and checking out the branches if you change them.

In case you want to get rid of everything, `deployah purge` will delete all repositories, after asking you if you are really sure. The command is not yet aware of uncommited changes and dirty work trees - so be careful!

A not yet implemented, but planned feature is the command `deployah installah` - this command will use the not yet inveted `installah` tool, to install all the repositories according to an `installah.toml` file in their root. Installah will not be a build and install tool itself, but use whichever build system your project is based on. It will only provide a uniform interface to it and add some of the things commonly missing, like service file placement and service reload.

A future version of Installah will also not install the software into the actual system root, but will create a root tree in the deployahment directory, which will then be integrated with the actual system root using overlayfs or fusefs.

## Install

* `curl --proto '=https' --tlsv1.2 -sSf https://sh.rustup.rs | sh`
* `sudo apt install libssl-dev git`
* `curl -sSL https://raw.githubusercontent.com/python-poetry/poetry/master/get-poetry.py | python -`
* `cargo install deployah`
