use crate::Config;
use eyre::{Context, Result};
use git2::{FetchOptions, RemoteCallbacks};
use git2_credentials::CredentialHandler;
use rayon::prelude::*;

pub fn get_fetch_options() -> Result<FetchOptions<'static>> {
    let git_config = git2::Config::open_default()?;

    let mut callbacks = RemoteCallbacks::new();
    let mut cred_handler = CredentialHandler::new(git_config);
    callbacks.credentials(move |url, username, allowed| {
        cred_handler.try_next_credential(url, username, allowed)
    });

    let mut fetch_options = FetchOptions::new();
    fetch_options
        .remote_callbacks(callbacks)
        .download_tags(git2::AutotagOption::All)
        .update_fetchhead(true);

    Ok(fetch_options)
}

pub fn update() -> Result<()> {
    let config: Config =
        toml::from_str(&std::fs::read_to_string("deployah.toml")?)?;

    match &config.repos {
        None => println!("No repositories specified"),
        Some(repos) => {
            repos.par_iter().try_for_each(|repo_config| {
                println!("Checking repository '{}'", repo_config.name);
                crate::tool::git::apply(repo_config).context("Could not apply")
            })?;
        }
    }
    Ok(())
}
