use crate::Config;
use eyre::{Context, Result};
use rayon::prelude::*;
use std::io::{self, Write};
use std::path::Path;
use std::process::Command;

pub fn purge() -> Result<()> {
    if Command::new("git")
        .arg("diff")
        .arg("--quiet")
        .output()
        .context("Could not run git")?
        .status
        .success()
    {
        print!("Do you really want to purge all repositories? [yes/no] ");
        io::stdout().flush()?;
        let answer: String = text_io::read!();
        if answer == "yes" {
            let config: Config =
                toml::from_str(&std::fs::read_to_string("deployah.toml")?)?;

            match &config.repos {
                None => println!("No repositories specified"),
                Some(repos) => repos.par_iter().try_for_each(|repo_config| {
                    std::fs::remove_dir_all(Path::new(&repo_config.name)).with_context(|| {
                        format!("Could not delete repostiroy '{}'", repo_config.name)
                    })
                })?,
            }
        }
    } else {
        println!("You have uncommited changes, please handle them before purging");
    };

    Ok(())
}
