use eyre::{Context, Result};

use crate::Config;

pub fn init(title: &str, name: &str) -> Result<()> {
    let config = Config {
        title: title.to_string(),
        name: name.to_string(),
        repos: None,
    };
    if !std::path::Path::new("deployah.toml").exists() {
        std::fs::write("deployah.toml", toml::to_string(&config)?)
            .context("Writing deployah.toml")?;
    } else {
        println!("Deployahment is already initialized.");
    };
    Ok(())
}
