use eyre::{Context, Result};

use crate::Config;

pub fn add(name: &str, url: &str, branch: &str) -> Result<()> {
    let mut config = load_config().context("Reading deployah.toml")?;
    config.add(name, url, branch);
    store_config(config).context("Writing deployah.toml")?;

    Ok(())
}

fn store_config(config: Config) -> Result<()> {
    Ok(std::fs::write("deployah.toml", toml::to_string(&config)?)?)
}

fn load_config() -> Result<Config> {
    Ok(toml::from_str(&std::fs::read_to_string("deployah.toml")?)?)
}
