// Copyright 2018-2021 the Deno authors. All rights reserved. MIT license.

mod comments;
mod parsed_source;
mod parsing;
mod text_info;
mod types;

#[cfg(feature = "view")]
pub use dprint_swc_ecma_ast_view as view;

pub use comments::*;
pub use parsed_source::*;
pub use parsing::*;
pub use text_info::*;
pub use types::*;

pub mod swc {
  #[cfg(feature = "bundler")]
  pub use swc_bundler as bundler;
  pub use swc_common as common;
  pub use swc_ecmascript as ecmascript;
}
