# Changelog

## [Unreleased]

## [0.13.0] - 2022-02-26

- Fixed no_std example/tests ([@korrat](https://github.com/korrat)) ([#247](https://github.com/sharksforarms/deku/pull/247))

### Breaking
- Sign extend integers ([@korrat](https://github.com/korrat)) ([#238](https://github.com/sharksforarms/deku/pull/238))

## [0.12.5] - 2021-11-11
- Show struct ident in assertion error message ([@wcampbell0x2a](https://github.com/wcampbell0x2a)) ([#239](https://github.com/sharksforarms/deku/pull/239))

## [0.12.4] - 2021-10-11
- Add Read/Write impls for generic arrays ([@xlambein](https://github.com/xlambein)) ([#235](https://github.com/sharksforarms/deku/pull/235))

## [0.12.3] - 2021-07-06
- Bug fix for structs/enums which also define a `to_bytes` function

## [0.12.2] - 2021-06-15
- Bug fix for in primitive bitslice convertion ([issue](https://github.com/sharksforarms/deku/issues/224)/[commit](https://github.com/sharksforarms/deku/commit/8d58bc6c65a9f3305d22ebe1bb5a685c39295863))
- Added Miri tests including testing on big endian target ([#211](https://github.com/sharksforarms/deku/pull/211))

## [0.12.1] - 2021-05-25
- Add support for raw indentifiers ([@Visse](https://github.com/visse)) ([#221](https://github.com/sharksforarms/deku/pull/221))
- Dependency updates

## [0.12.0] - 2021-04-13

### Breaking
- `const_generics` feature enabled by default

### Added
- Add optional `const_generics` feature ([@soruh](https://github.com/soruh)) ([#187](https://github.com/sharksforarms/deku/pull/187))
    - This allows for reading/writing arrays with >32 elements when enabled
- DekuRead+DekuWrite implementations for Cow<T> ([@abungay](https://github.com/abungay)) ([#186](https://github.com/sharksforarms/deku/pull/186))
- DekuRead+DekuWrite implementations for HashMap ([@abungay](https://github.com/abungay)) ([#199](https://github.com/sharksforarms/deku/pull/199))
- DekuRead+DekuWrite implementations for HashSet ([@abungay](https://github.com/abungay)) ([#199](https://github.com/sharksforarms/deku/pull/199))
- DekuWrite implementations for &T ([@abungay](https://github.com/abungay)) ([#199](https://github.com/sharksforarms/deku/pull/199))
- DekuRead+DekuWrite implementations for tuple ([@abungay](https://github.com/abungay)) ([#198](https://github.com/sharksforarms/deku/pull/198))

### Other
- Updated dependencies
- Updated wasm example
- Fix: Parenthesize pad/update attributes ([@wcampbell0x2a](https://github.com/wcampbell0x2a)) ([#195](https://github.com/sharksforarms/deku/pull/195))
- Fixed failing code coverage ([@abungay](https://github.com/abungay)) ([#200](https://github.com/sharksforarms/deku/pull/200))
- Update DekuRead documentation ([@caass](https://github.com/caass)) ([fcfdc24](https://github.com/sharksforarms/deku/commit/fcfdc24eca1b8663f9a2cd2d0d8ad6534b08a862)/[#196](https://github.com/sharksforarms/deku/pull/196))
- Updated hexlit dependency ([@inspier](https://github.com/inspier)) ([#189](https://github.com/sharksforarms/deku/pull/189))
- Refactoring and code improvements ([@wcampbell0x2a](https://github.com/wcampbell0x2a))

## [0.11.0] - 2020-02-25

### Breaking
- Removed `bitvec` from `deku::prelude` ([#181](https://github.com/sharksforarms/deku/pull/181))
    - This will break custom `reader` and `writer` function definitions
    - `bitvec` is re-exported via: `deku::bitvec::` (this contains `bitvec::prelude::*`)

### Added
- Added `DekuEnumExt` to provide extra utility functions to enums. ([#176](https://github.com/sharksforarms/deku/pull/176))
    - This trait is implemented on enums derived with `#[derive(DekuRead)]`
    - This trait currently contains 1 function: `deku_id()`
    - `deku_id` can be called on an enum variant to get the deku `id` of the variant
- Added `Incomplete(NeedSize)` variant on `DekuError` ([#177](https://github.com/sharksforarms/deku/pull/177))
- Added `CODE_OF_CONDUCT.md`
- Code improvements ([@wcampbell0x2a](https://github.com/wcampbell0x2a))

## [0.10.1] - 2020-02-25

- Update bitvec dependency to fix [build failures](https://github.com/bitvecto-rs/bitvec/issues/105)

## [0.10.0] - 2020-01-09
### Breaking
- Enum's which don't specify an `id` attribute now default to their discriminant value
instead of being treated as a catch-all ([#139](https://github.com/sharksforarms/deku/pull/139))
- Removed `BitSize` in favor of a new enum `Size` with two variants, `Bits` and `Bytes` ([#138](https://github.com/sharksforarms/deku/pull/138))
- Added namespacing to internal variables. `deku::` is used to access internal variables in token fields. ([#150](https://github.com/sharksforarms/deku/pull/150))
For example, `reader = "my_reader(deku::rest, deku::bit_offset)"` or `writer = "my_writer(deku::output)"`
- Introduced a lifetime to `DekuRead` in support of zero-copy reading ([#158](https://github.com/sharksforarms/deku/pull/158))

### Added
- Zero-copy reading on &[u8] ([#158](https://github.com/sharksforarms/deku/pull/158))
- Padding related attributes: `pad_bits_before`, `pad_bytes_before`, `pad_bits_after`, `pad_bytes_after` ([#163](https://github.com/sharksforarms/deku/pull/163))
- Assertion related attributes: `assert`, `assert_eq` ([#164](https://github.com/sharksforarms/deku/pull/164))
- Ability to use more types in enum's `type` attribute ([#162](https://github.com/sharksforarms/deku/pull/162))
- Ability to use LitByteStr in enum's `id` attribute, for example `id = b"0x01"` ([#162](https://github.com/sharksforarms/deku/pull/162))
- Access to read offset via bit_offset and byte_offset internal variables. ([#149](https://github.com/sharksforarms/deku/pull/149))
These are accessed via `deku::` namespace, `deku::bit_offset` and `deku::byte_offset`. ([#150](https://github.com/sharksforarms/deku/pull/150))
- `#[deku(temp)]` attribute, enabled via `deku_derive` proc-macro attribute. ([#136](https://github.com/sharksforarms/deku/pull/136))
This allows reading/use of a field without it being stored in the container.
- DekuRead+DekuWrite implementations for CString ([#144](https://github.com/sharksforarms/deku/pull/144))
- DekuRead+DekuWrite implementations for NonZeroT types ([#140](https://github.com/sharksforarms/deku/pull/140))
- DekuRead+DekuWrite implementations for bool ([#161](https://github.com/sharksforarms/deku/pull/161))
- DekuRead+DekuWrite implementations for () ([#159](https://github.com/sharksforarms/deku/pull/159))
- DekuRead+DekuWrite implementations for Box<T> and Box<[T]> ([#160](https://github.com/sharksforarms/deku/pull/160))

### Other
- Internal code/test refactoring
- Code improvements ([@myrrlyn](https://github.com/myrrlyn), [@wcampbell0x2a](https://github.com/wcampbell0x2a), [@inspier](https://github.com/inspier))

## [0.9.3] - 2020-12-14
- Patch release to fix semver break in darling,
[this has since been fixed](https://github.com/TedDriggs/darling/issues/107)

## [0.9.2 - yanked] - 2020-12-14
- Patch release to fix semver break in darling,
[this has since been fixed](https://github.com/TedDriggs/darling/issues/107)

## [0.9.1] - 2020-10-31
- Changed minimum bitvec version to 0.19.4 to have desired `offset_from`
functionality (https://github.com/myrrlyn/bitvec/issues/86). This was missed in
0.9.0 release.
- Code improvements ([@wcampbell0x2a](https://github.com/wcampbell0x2a))

## [0.9.0] - 2020-10-30

- Added `magic` attribute, this allows the ability to specify a set of bytes
which must be present at the start of the data
([@samuelsleight](https://github.com/samuelsleight))
- Added `until` attribute, this allows the ability to read until a given predicate
([@samuelsleight](https://github.com/samuelsleight))
- Added `bits_read` and `bytes_read` container attributes, this allows the ability to specify
an amount of bits/bytes to read inside a Vec<T>
([@samuelsleight](https://github.com/samuelsleight))
- Improved documentation
- Refactored test cases
- Code improvements ([@wcampbell0x2a](https://github.com/wcampbell0x2a))

## [0.8.0] - 2020-09-29

- `write` now takes a `&mut BitVec` instead of returning a BitVec, this optimization
speeds up serialization ([@agausmann](https://github.com/agausmann))

The following items have been renamed: ([@wcampbell0x2a](https://github.com/wcampbell0x2a))
- Renamed `id_type` in favor of `type`
- Renamed `id_bits` in favor of `bits`
- Renamed `id_bytes` in favor of `bytes`

Internal:
- Updated criterion to latest
- Using tarpaulin for code coverage now
- Swapped hex! macro ([@inspier](https://github.com/inspier))
- Code improvements ([@wcampbell0x2a](https://github.com/wcampbell0x2a))

## [0.7.2] - 2020-09-02

- Added `ctx_default` attribute, this allows the ability to specify defaults to
types accepting a `ctx` if none are provided
- Updated documentation regarding the concept of context and how it
applies to some attributes
- Added validation to `id` attribute
- `endian` attribute now accepts an expression (still accepts `big` or `little`)
- Updated bitvec dependency

## [0.7.1] - 2020-07-31

- Added `id` attribute to top-level enums which allows to specify the enum id,
for example a value coming via a context variable

## [0.7.0] - 2020-07-28

- Added `cond` attribute which allows for conditional parsing or skipping of a field
- Added `id_pat` attribute which allows pattern matching for enum variants

Community:

- Added `ctx` attribute which adds the ability to pass context to child parsers from the parent ([@constfold](https://github.com/constfold))
- Internal refactoring of `endian`, `bits` and `count` attributes, they are now sugar around the `ctx` ([@constfold](https://github.com/constfold))
- Renamed `to_bitvec` to `to_bits` ([@wcampbell0x2a](https://github.com/wcampbell0x2a))

## [0.6.1] - 2020-07-06

- Enum variant specified without an `id` attribute is now considered the catch-all

## [0.6.0] - 2020-06-22

- Added `DekuContainerRead` and `DekuContainerWrite` to expose `from_bytes`, `to_bytes` and `to_bitvec`
- Added `release.toml`
- Added `CHANGELOG.md` to track changes

[Unreleased]: https://github.com/sharksforarms/deku/compare/deku-v0.12.5...HEAD

[0.12.4]: https://github.com/sharksforarms/deku/compare/deku-v0.12.4...deku-v0.12.5

[0.12.4]: https://github.com/sharksforarms/deku/compare/deku-v0.12.3...deku-v0.12.4

[0.12.3]: https://github.com/sharksforarms/deku/compare/deku-v0.12.2...deku-v0.12.3

[0.12.2]: https://github.com/sharksforarms/deku/compare/deku-v0.12.1...deku-v0.12.2

[0.12.1]: https://github.com/sharksforarms/deku/compare/deku-v0.12.0...deku-v0.12.1

[0.12.0]: https://github.com/sharksforarms/deku/compare/deku-v0.11.0...deku-v0.12.0

[0.11.0]: https://github.com/sharksforarms/deku/compare/deku-v0.10.1...deku-v0.11.0

[0.10.1]: https://github.com/sharksforarms/deku/compare/deku-v0.10.0...deku-v0.10.1

[0.10.0]: https://github.com/sharksforarms/deku/compare/deku-v0.9.3...deku-v0.10.0

[0.9.3]: https://github.com/sharksforarms/deku/compare/deku-v0.9.1...deku-v0.9.3

[0.9.2]: https://github.com/sharksforarms/deku/compare/deku-v0.9.1...deku-v0.9.2

[0.9.1]: https://github.com/sharksforarms/deku/compare/deku-v0.9.0...deku-v0.9.1

[0.9.0]: https://github.com/sharksforarms/deku/compare/deku-v0.8.0...deku-v0.9.0

[0.8.0]: https://github.com/sharksforarms/deku/compare/deku-v0.7.2...deku-v0.8.0

[0.7.2]: https://github.com/sharksforarms/deku/compare/deku-v0.7.1...deku-v0.7.2

[0.7.1]: https://github.com/sharksforarms/deku/compare/deku-v0.7.0...deku-v0.7.1

[0.7.0]: https://github.com/sharksforarms/deku/compare/deku-v0.6.1...deku-v0.7.0

[0.6.1]: https://github.com/sharksforarms/deku/compare/deku-v0.6.0...deku-v0.6.1
