# Log frames

Each log statement produces one log frame.
Consider this log call:
(let's include the timestamp this time)

``` rust
# extern crate defmt;
defmt::info!("answer={=u8}", 42);
// on the wire: [2, 125, 42] <- arguments
//  string index ^  ^^^ timestamp
```

A log frame will consist of:

- A string index that must be either of the error, warn, info, debug or trace kind.
  - String indices generated by `write!` (used in `Format` implementations) are of a different kind
- A timestamp (LEB128 encoded)
- Zero or more formatting arguments

To be able to decode the last component the host will have to lookup the format string, whose index is the first part of the log frame, and parse it.
Parsing that string will tell the host how many and how big (in bytes) the formatting arguments are.
