# Summary

[Introduction](./introduction.md)
- [User guide](./user-guide.md)
  - [Setup](./setup.md)
    - [Libraries](./setup-library.md)
    - [Applications](./setup-app.md)
  - [Logging macros](./macros.md)
    - [Primitives](./primitives.md)
    - [Bitfields](./bitfields.md)
    - [Interned strings](./istr.md)
    - [Format slices / arrays](./format-slices.md)
    - [Display hints](./hints.md)
  - [Implementing Format](./format.md)
  - [Filtering](./filtering.md)
  - [Timestamps](./timestamps.md)
  - [#[global_logger]](./global-logger.md)
  - [panic! and assert!](./panic.md)
  - [Printers](./printers.md)
- [Design & impl details](./design.md)
  - [Interning](./interning.md)
    - [Dealing with duplicates](./duplicates.md)
    - [Logging levels](./linker-sections.md)
  - [Serialization](./serialization.md)
    - [Interned strings](./ser-istr.md)
    - [Integers](./ser-integers.md)
    - [Slices](./ser-slices.md)
    - [Strings](./ser-str.md)
    - [Arrays](./ser-array.md)
    - [Bitfield](./ser-bitfield.md)
    - [Bool](./ser-bool.md)
    - [Format](./ser-format.md)
    - [Format slice](./ser-format-slice.md)
  - [Single Format trait](./design-format.md)
  - [Timestamp](./design-timestamp.md)
  - [Global logger](./design-global-logger.md)
    - [Re-entrancy](./re-entrancy.md)
    - [Acquire-release](./acq-rel.md)
    - [Evaluation order](./eval-order.md)
    - [Preemption](./preemption.md)
  - [Deserialization](./deserialization.md)
    - [Log frames](./log-frame.md)
    - [Lookup](./lookup.md)
