## DEEPWELL

<p>
  <a href="https://github.com/scpwiki/wikijump/actions?query=workflow%3A%22%5Bdeepwell%5D+Rust%22">
    <img src="https://github.com/scpwiki/wikijump/workflows/%5Bdeepwell%5D%20Rust/badge.svg"
         alt="Build status">
  </a>

  <!-- TODO publish to crates.io
  <a href="https://docs.rs/deepwell">
    <img src="https://docs.rs/deepwell/badge.svg"
         alt="docs.rs link">
  </a>
  -->
</p>

DEEPWELL is an experimental backend system to provide core wiki operations via an API for Wikijump.
This is intended as an internal API consumed by the web server as part of its logical tasks.

The lint `#![forbid(unsafe_code)]` is set, and therefore this crate has only safe code.

Available under the terms of the GNU Affero General Public License. See [LICENSE.md](LICENSE.md).

### Development

If you have [`sea-orm-cli`](https://www.sea-ql.org/SeaORM/docs/generate-entity/sea-orm-cli/), and have a local instance of Wikijump running, you can use the following script to autogenerate SeaORM model files:

```sh
$ scripts/generate-models.sh
```

#### Structure

The primary organization of the crate is as follows:

* `api/` &mdash; Web server definition, such as its routes and related structures.
  * Each API is namespaced based on its version. The primary version of interest is the "internal" API, which is consumed by PHP and not meant for outside consumption due to it providing unguarded access.
* `methods/` &mdash; Implementations for individual routes provision above.
* `services/` &mdash; "Services", or logical encapsulations of different concepts or operations.
  * For instance, the `ParentService` allows retrieving and storing data related to parent-child page relationships. You can think of it as "wrapping" the `page_parent` table.
  * Similarly, the `PageService` encapsulates the `page` table, but also wraps all the other operations contained with the logical concept of the "page", such as creating new revisions using the `RevisionService` as part of the "edit" method.
* `locales/` &mdash; Provides localization methods, interpreting the [Fluent](https://projectfluent.org/) translation files.
* `models/` &mdash; Primarily auto-generated by Sea-ORM, these files allow for interfacing with the database.
* Other files are utilities, and are generally understandable by looking at their contents..

The routes are defined in `api/`, with their implementations in `methods/`, and the structures they rely on in `services/<name>/structs.rs`. The services invoked to encapsulate logical operations are at `services/<name>.rs` or `services/<name>/service.rs`.

### Compilation

This executable targets the latest stable Rust. At time of writing, that is `1.60.0`.

```sh
$ cargo build --release
```

### Testing

Tests have not yet been implemented, but when they are, run:

```sh
$ cargo test
```

Add `-- --nocapture` to the end if you want to see test output.

### Development

```sh
$ cargo fmt     # Ensure code is formatted
$ cargo clippy  # Check code for lints
```
