use core::ops::Mul;

#[derive(Debug, Clone, Copy, PartialEq)]
struct Pauli {
    // TODO: bitvec to not be stuck with u8
    x: u8,
    z: u8,
    // Qudit dimension
    d: u8,
}

impl Pauli {
    pub fn new(x: u8, z: u8, d: u8) -> Self {
        Pauli { x, z, d }
    }
}

impl Mul for Pauli {
    type Output = Self;
    fn mul(self, rhs: Self) -> Self::Output {
        assert_eq!(self.d, rhs.d);
        Self::new(self.x + rhs.x, self.z + rhs.z, self.d)
    }
}

#[cfg(test)]
mod tests {
    #[allow(non_snake_case)]
    #[test]
    fn it_works() {
        use crate::Pauli;
        let X = Pauli::new(1, 0, 3);
        let Z = Pauli::new(0, 1, 3);

        let XZ = X*Z;
        assert_eq!(Pauli::new(1,1,3), XZ);
    }
}
