# Decorators
A library to generate decorator methods.
This can be useful if you need a lot of decorators.

The Decorator macro generates a decorator method for each marked field. A field can be marked with the `#[dec]` field in front.
## Example
```rust
#[derive(Decorator)]
struct Widget {
    #[dec]
    width: u32,
    #[dec]
    height: u32,
}
```
Generates into:
```rust
struct Widget {
    width: u32,
    height: u32,
}
impl Widget {
    pub fn width(self, width: u32) -> Self {
        Self {
            width,
            ..self
        }
    }
    pub fn height(self, height: u32) -> Self {
        Self {
            height,
            ..self
        }
    }
}
```
Which can be used like:
```rust
let w = some_widget.width(10).height(20);
assert_eq!(w, Widget {width: 10, height: 20});
```