# Deckster

Spaced repetition in the terminal. Inspired by Anki
and uses a modified SM2 algorithm.

Only supports Unix systems.

![deckster](./assets/screenshot.png)


## Installation

Depends on having the rust compiler. Rust can be installed from your
package manager, if not see [here](https://doc.rust-lang.org/book/ch01-01-installation.html).

Manual installation:
```sh
git clone https://gitlab.com/prince_bett/deckster
cd deckster
make install
```

Using Cargo :
```sh
cargo install deckster.
```

> Note: make sure ".cargo/bin/" is in your path.

## Usage

```sh
deckster [flag] [arg]

# for help: deckster -h
```

Cards should be saved in [TOML](https://toml.io/en/) format.
It makes it easier to read and write cards in your favourite editor.
> See `deckster -s`

Only text is supported. Users could add urls to Q/A fields
and use their terminal to grab them and open multimedia content.

```
Keybindings
-----------

SPACE   :   Reveal answer. When pressed again reveals rating options.
RETURN  :   Submit rating and move to the next card.
l/RIGHT :   Select next rating option.
h/LEFT  :   Select previous rating option.
q/ESC   :   Exit application.
```

## Contributing.

I'd love to hear from you ! Please file issues with
bug reports or ( minimalist ) feature suggestions.
