/*
 * @Author: tzw
 * @Date: 2021-10-31 23:26:50
 * @LastEditors: tzw
 * @LastEditTime: 2021-11-17 23:06:52
 */
use std::collections::HashMap;
use serde::{Deserialize, Serialize};

/**
eventuate 消息定义
*/
pub trait Imessage{
     fn get_id(&self) -> Option<String>;
     fn get_headers(&self) -> HashMap<String, String>;
     fn get_payload(&self)-> Option<String>;
     fn get_header(&self, name: String)-> Option<String>;
     fn get_required_header(&self, name: String)-> String;
     fn has_header(&self, name: &str)-> bool;
}

#[derive(Serialize, Deserialize,Clone, Debug)]
pub struct MessageImpl{
    pub payload: Option<String>,
    pub headers: Option<HashMap<String, String>>,
}


impl Imessage for MessageImpl {
    fn get_id(&self) -> Option<String> {
        self.get_header("ID".to_string())
    }

    fn get_headers(&self) -> HashMap<String, String> {
        match &self.headers{
            Some(h) => h.clone(),
            None => return HashMap::new(),
        }
    }

    fn get_payload(&self)-> Option<String> {
        match &self.payload{
            Some(payload) => Some(payload.to_string()),
            None =>  None,
        }
    }

    fn get_header(&self, name: String)-> Option<String> {
       match &self.headers {
           Some(h) => Some(h.get(&name).unwrap().to_string()),
           None => None,
       }

    }

    fn get_required_header(&self, name: String)-> String {
        match &self.headers {
            Some(h) => h.get(&name).unwrap().to_string(),
            None => panic!("找不到 Key"),
        }
    }

    fn has_header(&self, name: &str)-> bool {
        match &self.headers {
            Some(h) => h.contains_key(name),
            None => false,
        }
    }
}


impl MessageImpl {



}