/*
 * @Author: tzw
 * @Date: 2021-11-04 01:44:55
 * @LastEditors: tzw
 * @LastEditTime: 2021-11-09 04:54:17
 */
 use std::time::Duration;

use actix_web::*;

use ddd_dapr::dapr::subscriber::*;
use tonic::{transport::Server, Request, Response, Status};
use dapr::{
    appcallback::*,
    dapr::dapr::proto::runtime::v1::app_callback_server::{AppCallback, AppCallbackServer},
};

use std::thread;

#[tokio::main]
async fn main() -> Result<(), Box<dyn std::error::Error>> {
   let http_server= thread::spawn(move || {
    actix_web::rt::System::new("test").block_on( async move {
    HttpServer::new(|| {
        App::new().service(
            // prefixes all resources and routes attached to it...
            web::scope("/app")
                // ...so this handles requests for `GET /app/index.html`
              //  .route("/index.html", web::get().to(index)),
        )
    })
    .bind("127.0.0.1:8080").unwrap()
    .run()
    .await;
});

});
//join!(http_server);
   
    let addr = "[::]:50051".parse().unwrap();
    let callback_service = AppCallbackService::default();
    println!("AppCallback server listening on: {}", addr);

    // Create a gRPC server with the callback_service.
    Server::builder()
        .add_service(AppCallbackServer::new(callback_service))
        .serve(addr)
        .await?;

      

    Ok(())
}


// pub async fn init_dapr() {
//     let addr = "[::]:50051".parse().unwrap();

//     let callback_service = AppCallbackService::default();

//     println!("AppCallback server listening on: {}", addr);

//     // Create a gRPC server with the callback_service.
//     Server::builder()
//         .add_service(AppCallbackServer::new(callback_service))
//         .serve(addr);
//         // .await;
// }
