/*
 * @Author: tzw
 * @Date: 2021-11-03 14:50:18
 * @LastEditors: tzw
 * @LastEditTime: 2021-11-03 21:53:13
 */

 #[cfg(test)]
 pub mod test{
    use crate::dapr::controller::*;
  
   
    
    // use futures_util::stream::StreamExt;
    // use futures_util::stream::TryStreamExt;

    use actix_web::{test,  App};

    #[actix_rt::test]
    async fn test_dapr_config() {
        let mut app = test::init_service(App::new().configure(dapr_service_config)).await;
        let req = test::TestRequest::get().uri("/dapr/config").to_request();

        let  resp = test::call_service(&mut app, req).await;
        let status=resp.status();
        let result=test::read_body(resp).await;
      
        println!("返回body：{:#?}",result);
        
        assert!(status.is_success());
    }
    #[actix_rt::test]
    async fn test_dapr_subscribe(){
        let mut app = test::init_service(App::new().configure(dapr_service_config)).await;
        let req = test::TestRequest::get().uri("/dapr/subscribe").to_request();
        let  resp = test::call_service(&mut app, req).await;

        let status=resp.status();
        let result=test::read_body(resp).await;
      
        println!("返回body:{:#?}",result);
        
        assert!(status.is_success());
    }

    #[actix_rt::test]
    async fn test_deactivate_actor(){
        let mut app = test::init_service(App::new().service(deactivate_actor)).await;
        let req = test::TestRequest::delete().uri("/actors/actor1/123").to_request();
        let  resp = test::call_service(&mut app, req).await;

        let status=resp.status();
        let result=test::read_body(resp).await;
      
        println!("返回body：{:#?}",result);
        
        assert!(status.is_success());
    }

    #[actix_rt::test]
    async fn test_invoke_actor_method(){
        let mut app = test::init_service(App::new().configure(dapr_service_config)).await;
        let req = test::TestRequest::put().uri("/actors/actor1/123/method/method1").to_request();

        let  resp = test::call_service(&mut app, req).await;
        let status=resp.status();
        let result=test::read_body(resp).await;
      
        println!("返回body：{:#?}",result);
        
        assert!(status.is_success());
    }

    #[actix_rt::test]
    async fn test_invoke_actor_reminder(){
        let mut app = test::init_service(App::new().configure(dapr_service_config)).await;
        let req = test::TestRequest::put().uri("/actors/actor1/123/method/remind/remind1").to_request();


        let  resp = test::call_service(&mut app, req).await;
        let status=resp.status();
        let result=test::read_body(resp).await;
        let json:ActorPathDto=serde_json::from_slice(&result).unwrap();
      
        println!("返回body json：{:#?}",json);
        
        assert!(status.is_success());
    }
 }