use std::collections::HashMap;

/*
 * @Author: tzw
 * @Date: 2021-11-02 20:30:11
 * @LastEditors: tzw
 * @LastEditTime: 2021-11-03 21:57:04
 */
use actix_web::route;
use actix_web::*;
use serde::{Deserialize, Serialize};

use crate::pubsub::DaprTopicSubscription;




   /**
   * Returns the list of subscribed topics.
   * @return List of subscribed topics.
   * @throws IOException If cannot generate list of topics.
   */
 #[route("/dapr/config", method = "GET")]
 pub async fn dapr_config()-> impl Responder {
    HttpResponse::Ok().finish()
}
  /**
   * Handles API to deactivate an actor.
   * @param type Actor type.
   * @param id Actor Id.
   * @return Void.
   */
 #[get("/dapr/subscribe")]
 pub async fn dapr_subscribe()-> impl Responder {
    let mut subscriptions:Vec<DaprTopicSubscription> =Vec::new();
    let dapr_topic_subscription=DaprTopicSubscription {
      pubsub_name: Some("messagebus".to_string()),
      topic:Some("topic1".to_string()),
      route:Some("path1".to_string()),
      metadata:None
    };  
   subscriptions.push(dapr_topic_subscription);
  
   let mut metadata:HashMap<String,String>=HashMap::new();
   metadata.insert("key".to_string(),"value".to_string());
   metadata.insert("key1".to_string(),"value1".to_string());
   let dapr_topic_subscription=DaprTopicSubscription {
    pubsub_name: Some("messagebus".to_string()),
    topic:Some("topic2".to_string()),
    route:Some("path2".to_string()),
    metadata:Some(metadata)
  };  

 subscriptions.push(dapr_topic_subscription);
  
 return HttpResponse::Ok()
    .set_header("Access-Control-Allow-Origin", "*")
    .set_header("Cache-Control", "no-cache")
    .set_header("Content-Type", "text/json;charset=UTF-8")
    .body(serde_json::to_string(&subscriptions).unwrap());
}

  /**
   * Handles API to deactivate an actor.
   * @param type Actor type.
   * @param id Actor Id.
   * @return Void.
   */
#[delete("/actors/{type}/{id}")]
pub async fn deactivate_actor(actor:web::Path<ActorPathDto>)-> impl Responder{
    HttpResponse::Ok().finish()
}

  /**
   * Handles API to invoke an actor's method.
   * @param type Actor type.
   * @param id Actor Id.
   * @param method Actor method.
   * @param body Raw request body.
   * @return Raw response body.
   */
#[put("/actors/{type}/{id}/method/{method}")]
pub async fn invoke_actor_method(actor:web::Path<ActorPathDto>)-> impl Responder {
    let actor=actor.into_inner();

  return HttpResponse::Ok()
         .set_header("Access-Control-Allow-Origin", "*")
         .set_header("Cache-Control", "no-cache")
         .set_header("Content-Type", "text/json;charset=UTF-8")
         .body(serde_json::to_string(&actor).unwrap());
}

  /**
   * Handles API to trigger an actor's timer.
   * @param type Actor type.
   * @param id Actor Id.
   * @param timer Actor timer's name.
   * @param body Raw request's body.
   * @return Void.
   */
#[put("/actors/{type}/{id}/method/timer/{timer}")]
pub async fn invoke_actor_timer(actor:web::Path<ActorPathDto>)-> impl Responder {
  let actor=actor.into_inner();
 
 
  return HttpResponse::Ok()
         .set_header("Access-Control-Allow-Origin", "*")
         .set_header("Cache-Control", "no-cache")
         .set_header("Content-Type", "text/json;charset=UTF-8")
         .body(serde_json::to_string(&actor).unwrap());
}
 /**
   * Handles API to trigger an actor's reminder.
   * @param type Actor type.
   * @param id Actor Id.
   * @param reminder Actor reminder's name.
   * @param body Raw request's body.
   * @return Void.
   */
#[put("/actors/{type}/{id}/method/remind/{reminder}")]
pub async fn invoke_actor_reminder(actor: web::Path<ActorPathDto>,req: HttpRequest)-> impl Responder {
  let actor=actor.into_inner();
 

  return HttpResponse::Ok()
         .set_header("Access-Control-Allow-Origin", "*")
         .set_header("Cache-Control", "no-cache")
         .set_header("Content-Type", "text/json;charset=UTF-8")
         .body(serde_json::to_string(&actor).unwrap());
}
/// 用于接收actor 的 url 参数
#[derive(Serialize, Deserialize, Clone, Debug)]
pub struct ActorPathDto {
  #[serde(rename="type")]
   pub actor_type: Option<String>,
   pub id:Option<String>,
   pub method:Option<String>, 
   pub timer:Option<String>,
   pub reminder:Option<String>,        
}
/// dapr 相关接口注册成为 actix_web 的 service
pub fn dapr_service_config(cfg: &mut web::ServiceConfig) {
  cfg.service(dapr_config)
     .service(dapr_subscribe)
     .service(deactivate_actor) 
     .service(invoke_actor_reminder)
     .service(invoke_actor_method)
     .service(invoke_actor_timer)
  ;
}