
use proc_macro2::TokenStream;
use quote::{quote, quote_spanned};
use syn::spanned::Spanned;
use syn::{parse_macro_input, parse_quote, Data, DeriveInput, Fields, Generics, GenericParam};
use syn;



#[proc_macro_derive(DBfile)]
pub fn dbfile_derive(input: proc_macro::TokenStream) -> proc_macro::TokenStream {
    let input = parse_macro_input!(input as DeriveInput);
    let name = input.ident;

    let generics = add_trait_bounds(input.generics);
    let (impl_generics, ty_generics, where_clause) = generics.split_for_impl();


    let code = proc_write_line(&input.data);
    let code2 = proc_write_header(&input.data);

    // for database process
    let insert_db_fields_code = proc_db_fill_insert_fields(&input.data);
    let insert_db_value_code = proc_db_fill_insert_values(&input.data);
    let insert_db_my_fields_code = proc_db_fill_insert_myfields(&input.data);
    
    // create db
    let create_table_code = proc_db_create_table(&input.data);


    let expanded = quote! {
        use std::fs::File;
        use std::fs::OpenOptions;
        use std::io::Write;
        use std::io::ErrorKind;
        use postgres::{Client, NoTls, types::ToSql};
        use regex::Regex;

        impl #impl_generics dbfile::DBfile for #name #ty_generics #where_clause {
            fn create_table(&self, conn: &mut Client, tablename:&str, primary_key: &str) {
                // create table 
                let create_table_sql = format!("CREATE TABLE IF NOT EXISTS {} {:?}", tablename, (#create_table_code));
                let trim_the_code = str::replace(create_table_sql.as_str(), "\"", "");

                // process primary key defined, your primary key don't appear at struct field tail
                let reg_primary_key = format!("({}[^,]*),", primary_key);

                let regex = Regex::new(&reg_primary_key).unwrap();
                let data = regex.captures(&trim_the_code).unwrap();
                let cap = &data[1];
                let new_str = format!("{} {}", cap, "primary key not null");

                let new_sql = str::replace(&trim_the_code, cap, &new_str);
                conn.batch_execute(new_sql.as_str()).unwrap();
            }

            fn insert(&self, conn: &mut Client, tablename: &str) {
                // insert db code , here test postgresql
                let insert_code_str = str::replace(stringify!(#insert_db_fields_code), "usize", "");

                // insert code and execute insert
                let insert_sql = format!("insert into {} ({}) values ({})", tablename, stringify!(#insert_db_my_fields_code), insert_code_str);
                let result = conn.execute(insert_sql.as_str(), &[
                    #insert_db_value_code
                ]);
                match result {
                    Ok(s) => println!("insert success!"),
                    Err(err) => println!("erorr: {:?}", err),
                }
            }

            fn write_csv_head(&self, path:&str) {
                // println!("execute code {:?}", stringify!(#code));

                let mut file = OpenOptions::new().append(true).open(path).unwrap_or_else(|error| {
                    if error.kind() == ErrorKind::NotFound {
                        File::create(path).unwrap_or_else(|error| {
                            panic!("Problem creating the file: {:?}", error);
                            })
                        } else {
                            panic!("Problem opening the file: {:?}", error);
                        }
                    }
                ); 
                #code2
            }

            fn write_csv_line(&self, path: &str, mode: &str)  {
                // println!("execute code {:?}", stringify!(#code));

                let mut is_append = false;
                if mode == "a" { is_append = true };
                
                let mut file = OpenOptions::new().append(is_append).open(path).unwrap_or_else(|error| {
                    if error.kind() == ErrorKind::NotFound {
                        File::create(path).unwrap_or_else(|error| {
                            panic!("Problem creating the file: {:?}", error);
                            })
                        } else {
                            panic!("Problem opening the file: {:?}", error);
                        }
                    }
                ); 
                #code
            }
        }
    };

    proc_macro::TokenStream::from(expanded)
}

fn add_trait_bounds(mut generics: Generics) -> Generics {
    for param in &mut generics.params {
        if let GenericParam::Type(ref mut type_param) = *param {
            type_param.bounds.push(parse_quote!(hello_macro::HelloMacro));
        }
    }
    generics
}

fn proc_db_create_table(data: &Data) -> TokenStream {
    match *data {
        Data::Struct(ref data) => {
            match data.fields {
                Fields::Named(ref fields) => {
                    let count = fields.named.iter().count();

                    let recurse = fields.named.iter().enumerate().map(|(i, f)| {
                        let name = &f.ident;

                        if i == count - 1 {
                            quote_spanned! { f.span() => 
                                dbfile::DBfield::create_db_fields(&self.#name, stringify!(#name).to_string())
                            }
                        }
                        else {
                            quote_spanned! { f.span() => 
                                dbfile::DBfield::create_db_fields(&self.#name, stringify!(#name).to_string()),
                            }
                        }   
                    });

                    quote! {
                        #(#recurse)*
                    }
                }
                Fields::Unnamed(ref _fields) => panic!("not process unnamed fileds"),
                Fields::Unit => panic!("not process unit fileds")
            }
        }
        Data::Enum(_) | Data::Union(_) => unimplemented!(),
    }
}

fn proc_write_header(data: &Data) -> TokenStream {
    match *data {
        Data::Struct(ref data) => {
            match data.fields {
                Fields::Named(ref fields) => {
                    let count = fields.named.iter().count();

                    let recurse = fields.named.iter().enumerate().map(|(i, f)| {
                        let name = &f.ident;

                        quote_spanned! { f.span() =>
                            if #i == #count - 1 {
                                file.write(format!("{:#?} \n", stringify!(#name)).as_bytes()).unwrap()
                            } else {
                                file.write(format!("{:#?},", stringify!(#name)).as_bytes()).unwrap()
                            }
                            // self.#name.push_str("_蠢")
                        }
                    });

                    quote! {
                        #(#recurse;)*
                    }
                }
                Fields::Unnamed(ref _fields) => panic!("not process unnamed fileds"),
                Fields::Unit => panic!("not process unit fileds")
            }
        }
        Data::Enum(_) | Data::Union(_) => unimplemented!(),
    }
}

fn proc_db_fill_insert_myfields(data: &Data) -> TokenStream {
    match *data {
        Data::Struct(ref data) => {
            match data.fields {
                Fields::Named(ref fields) => {
                    let count = fields.named.iter().count();

                    let recurse = fields.named.iter().enumerate().map(|(i, f)| {
                        let name = &f.ident;

                        if i == count - 1 {
                            quote_spanned! { f.span() => #name}
                        }
                        else {
                            quote_spanned! { f.span() => #name,}
                        }
                    });

                    quote! {
                        #(#recurse)*
                    }
                }
                Fields::Unnamed(ref _fields) => panic!("not process unnamed fileds"),
                Fields::Unit => panic!("not process unit fileds")
            }
        }
        Data::Enum(_) | Data::Union(_) => unimplemented!(),
    }
}

fn proc_db_fill_insert_values(data:&Data) -> TokenStream {
    match *data {
        Data::Struct(ref data) => {
            match data.fields {
                Fields::Named(ref fields) => {
                    let count = fields.named.iter().count();

                    let recurse = fields.named.iter().enumerate().map(|(i, f)| {
                        let name = &f.ident;

                        if i == count - 1 {
                            quote_spanned! { f.span() => &self.#name}
                        }
                        else {
                            quote_spanned! { f.span() => &self.#name,}
                        }
                    });

                    quote! {
                        #(#recurse)*
                    }
                }
                Fields::Unnamed(ref _fields) => panic!("not process unnamed fileds"),
                Fields::Unit => panic!("not process unit fileds")
            }
        }
        Data::Enum(_) | Data::Union(_) => unimplemented!(),
    }
}

fn proc_db_fill_insert_fields(data: &Data) -> TokenStream {
    match *data {
        Data::Struct(ref data) => {
            match data.fields {
                Fields::Named(ref fields) => {
                    let count = fields.named.iter().count();

                    let recurse = fields.named.iter().enumerate().map(|(i, f)| {
                        let number = i + 1;

                        if i == count - 1 {
                            quote_spanned! { f.span() => $#number}
                        }
                        else {
                            quote_spanned! { f.span() => $#number,}
                        }
                    });

                    quote! {
                        #(#recurse)*
                    }
                }
                Fields::Unnamed(ref _fields) => panic!("not process unnamed fileds"),
                Fields::Unit => panic!("not process unit fileds")
            }
        }
        Data::Enum(_) | Data::Union(_) => unimplemented!(),
    }
}

fn proc_write_line(data: &Data) -> TokenStream {
    match *data {
        Data::Struct(ref data) => {
            match data.fields {
                Fields::Named(ref fields) => {
                    let count = fields.named.iter().count();

                    let recurse = fields.named.iter().enumerate().map(|(i, f)| {
                        let name = &f.ident;

                        quote_spanned! { f.span() =>
                            if #i == #count - 1 {
                                file.write(format!("{:#?} \n", self.#name).as_bytes()).unwrap()
                            } else {
                                file.write(format!("{:#?},", self.#name).as_bytes()).unwrap()
                            }
                        }
                    });

                    quote! {
                        #(#recurse;)*
                    }
                }
                Fields::Unnamed(ref _fields) => panic!("not process unnamed fileds"),
                Fields::Unit => panic!("not process unit fileds")
            }
        }
        Data::Enum(_) | Data::Union(_) => unimplemented!(),
    }
}