
use proc_macro2::TokenStream;
use quote::{quote, quote_spanned};
use syn::spanned::Spanned;
use syn::{parse_macro_input, parse_quote, Data, DeriveInput, Fields, Generics, GenericParam};
use syn;


#[proc_macro_derive(DBfile)]
pub fn dbfile_derive(input: proc_macro::TokenStream) -> proc_macro::TokenStream {
    let input = parse_macro_input!(input as DeriveInput);
    let name = input.ident;

    let generics = add_trait_bounds(input.generics);
    let (impl_generics, ty_generics, where_clause) = generics.split_for_impl();


    let code = proc_write_line(&input.data);
    let code2 = proc_write_header(&input.data);

    let expanded = quote! {
        use std::fs::File;
        use std::fs::OpenOptions;
        use std::io::Write;
        use std::io::ErrorKind;


        impl #impl_generics dbfile::DBfile for #name #ty_generics #where_clause {
            fn write_csv_head(&self, path:&str) {
                // println!("execute code {:?}", stringify!(#code));

                let mut file = OpenOptions::new().append(true).open(path).unwrap_or_else(|error| {
                    if error.kind() == ErrorKind::NotFound {
                        File::create(path).unwrap_or_else(|error| {
                            panic!("Problem creating the file: {:?}", error);
                            })
                        } else {
                            panic!("Problem opening the file: {:?}", error);
                        }
                    }
                ); 
                #code2
            }

            fn write_csv_line(&self, path: &str, mode: &str)  {
                // println!("execute code {:?}", stringify!(#code));

                let mut is_append = false;
                if mode == "a" { is_append = true };
                
                let mut file = OpenOptions::new().append(is_append).open(path).unwrap_or_else(|error| {
                    if error.kind() == ErrorKind::NotFound {
                        File::create(path).unwrap_or_else(|error| {
                            panic!("Problem creating the file: {:?}", error);
                            })
                        } else {
                            panic!("Problem opening the file: {:?}", error);
                        }
                    }
                ); 
                #code
            }
        }
    };

    proc_macro::TokenStream::from(expanded)

}

fn add_trait_bounds(mut generics: Generics) -> Generics {
    for param in &mut generics.params {
        if let GenericParam::Type(ref mut type_param) = *param {
            type_param.bounds.push(parse_quote!(hello_macro::HelloMacro));
        }
    }
    generics
}

fn proc_write_header(data: &Data) -> TokenStream {
    match *data {
        Data::Struct(ref data) => {
            match data.fields {
                Fields::Named(ref fields) => {
                    let count = fields.named.iter().count();

                    let recurse = fields.named.iter().enumerate().map(|(i, f)| {
                        let name = &f.ident;

                        quote_spanned! { f.span() =>
                            if #i == #count - 1 {
                                file.write(format!("{:#?} \n", stringify!(#name)).as_bytes()).unwrap()
                            } else {
                                file.write(format!("{:#?},", stringify!(#name)).as_bytes()).unwrap()
                            }
                            // self.#name.push_str("_蠢")
                        }
                    });

                    quote! {
                        #(#recurse;)*
                    }
                }
                Fields::Unnamed(ref _fields) => panic!("not process unnamed fileds"),
                Fields::Unit => panic!("not process unit fileds")
            }
        }
        Data::Enum(_) | Data::Union(_) => unimplemented!(),
    }
}

fn proc_write_line(data: &Data) -> TokenStream {
    match *data {
        Data::Struct(ref data) => {
            match data.fields {
                Fields::Named(ref fields) => {
                    let count = fields.named.iter().count();

                    let recurse = fields.named.iter().enumerate().map(|(i, f)| {
                        let name = &f.ident;

                        quote_spanned! { f.span() =>
                            if #i == #count - 1 {
                                file.write(format!("{:#?} \n", self.#name).as_bytes()).unwrap()
                            } else {
                                file.write(format!("{:#?},", self.#name).as_bytes()).unwrap()
                            }
                        }
                    });

                    quote! {
                        #(#recurse;)*
                    }
                }
                Fields::Unnamed(ref _fields) => panic!("not process unnamed fileds"),
                Fields::Unit => panic!("not process unit fileds")
            }
        }
        Data::Enum(_) | Data::Union(_) => unimplemented!(),
    }
}