pub mod dbfield;

pub use self::dbfield::DBfield;

use postgres::{Client, NoTls};


pub trait DBfile {
    fn write_csv_head(&self, path: &str);
    fn write_csv_line(&self, path: &str, mode: &str);

    fn insert(&self, conn: &mut Client, tablename: &str);
    fn create_table(&self, conn: &mut Client, tablename: &str, primary_key:&str);
}

pub struct DBStore {}

impl DBStore {
    pub fn to_db<T>(datas: Vec<T>, conn_str: &str, tablename: &str)
    where
        T: DBfile,
    {
        let mut conn = Client::connect(conn_str, NoTls).unwrap();

        for data in datas.iter() {
            data.insert(&mut conn, tablename);
        }
    }

    pub fn create_table<T>(
        by_data: T,
        conn_str: &str,
        tablename: &str,
        primary_key: &str,
    ) where
        T: DBfile,
    {
        let mut conn = Client::connect(conn_str, NoTls).unwrap();
        by_data.create_table(&mut conn, tablename, primary_key);
    }

    pub fn to_csv<T>(datas: Vec<T>, path: &str, mode: &str, header: bool)
    where
        T: DBfile,
    {
        for (index, data) in datas.iter().enumerate() {
            if index == 0 {
                if header {
                    data.write_csv_head(path);
                }
                data.write_csv_line(path, mode);
            } else {
                data.write_csv_line(path, mode);
            }
        }
    }
}
