pub trait DBfile {
    fn write_csv_head(&self, path:&str);
    fn write_csv_line(&self, path: &str, mode: &str);
}

pub struct DBStore {}

impl DBStore {
    pub fn to_csv<T>(datas: Vec<T>, path: &str, mode: &str, header: bool) where T: DBfile {
        for (index, data) in datas.iter().enumerate() {
            if index == 0 {
                if header {
                     data.write_csv_head(path); 
                }
                data.write_csv_line(path, mode);
            } else {
                data.write_csv_line(path, mode);
            }
        }

    }
}