use super::Writer;
use csv;
use std::fs::File;

pub struct Csv {
    writer: csv::Writer<File>,
}

impl Writer for Csv {
    fn new(output: &str) -> Box<Self> {
        let writer = csv::Writer::from_path(output).expect("Build csv writer error!");
        Box::new(Csv { writer })
    }

    fn write_row(&mut self, row: Vec<String>) {
        self.writer
            .write_record(row)
            .expect("Write data to csv file error!");
        self.writer.flush().expect("Flush the csv writer error!");
    }
}
