use super::Writer;
use simple_excel_writer as excel;

pub struct Xls {
    work_book: excel::Workbook,
    sheet: excel::Sheet,
}

impl Writer for Xls {
    fn new(output: &str) -> Box<Self> {
        let mut work_book = excel::Workbook::create(output);
        let sheet = work_book.create_sheet("");
        Box::new(Xls { work_book, sheet })
    }

    fn write_row(&mut self, row: Vec<String>) {
        self.work_book
            .write_sheet(&mut self.sheet, |sheet_writer| {
                let row = excel::Row::from_iter(row.into_iter());
                sheet_writer
                    .append_row(row)
                    .expect("Write data to excel file error!");
                Ok(())
            })
            .expect("Write excel file error!");
    }
}
