mod args;
mod dumper;
mod writer;

use clap::{load_yaml, App};

use crate::dumper::Dumper;

fn main() {
    let yaml = load_yaml!("args.yml");
    let app = App::from(yaml);
    let options = match args::parse_args(app) {
        Some(options) => options,
        None => return,
    };

    match options.kind.as_str() {
        "sqlite" => {
            let sqlite = dumper::sqlite::Sqlite;
            sqlite.dump(&options);
        }
        "mysql" => {
            let mysql = dumper::mysql::Mysql;
            mysql.dump(&options);
        }
        "postgresql" => {
            let postgresql = dumper::postgresql::Postgresql;
            postgresql.dump(&options);
        }
        _ => (),
    }
}
