use clap::App;

#[derive(Debug, Default)]
pub struct Options {
    pub host: String,
    pub port: u16,
    pub kind: String,
    pub username: String,
    pub password: String,
    pub database: String,
    pub table: String,
    pub format: String,
    pub start: usize,
    pub rows: usize,
    pub output: String,
}

pub fn parse_args(app: App) -> Option<Options> {
    let mut options: Options = Default::default();
    let matches = app.get_matches();

    if let Some(host) = matches.value_of("host") {
        options.host = host.to_owned();
    }

    if let Some(port) = matches.value_of("port") {
        match port.parse::<u16>() {
            Ok(port) => options.port = port,
            Err(_) => {
                println!("Server port parse error!");
                return None;
            }
        }
    }

    if let Some(kind) = matches.value_of("kind") {
        options.kind = kind.to_owned();
    }

    if let Some(username) = matches.value_of("username") {
        options.username = username.to_owned();
    }

    if let Some(password) = matches.value_of("password") {
        options.password = password.to_owned();
    }

    match matches.value_of("database") {
        Some(database) => options.database = database.to_owned(),
        None => {
            println!("Database name is empty!");
            return None;
        }
    }

    match matches.value_of("table") {
        Some(table) => options.table = table.to_owned(),
        None => {
            println!("Table name is empty!");
            return None;
        }
    }

    if let Some(format) = matches.value_of("format") {
        options.format = format.to_owned();
    }

    if let Some(start) = matches.value_of("start") {
        match start.parse::<usize>() {
            Ok(start) => options.start = start,
            Err(_) => {
                println!("Start row parse error!");
                return None;
            }
        }
    }

    if let Some(rows) = matches.value_of("rows") {
        match rows.parse::<usize>() {
            Ok(rows) => options.rows = rows,
            Err(_) => {
                println!("Rows count parse error!");
                return None;
            }
        }
    }

    match matches.value_of("output") {
        Some(output) => {
            options.output = output.to_owned();
        }
        None => {
            println!("Output file path is empty!");
            return None;
        }
    }

    Some(options)
}
