use reqwest::blocking::Client;
use std::fs;
use std::io::stdout;
use std::path::{Path, PathBuf};


#[test]
fn test_response_as_string() -> anyhow::Result<()> {
    let mut response = Client::builder()
        .build()?
        .get("https://httpbin.org/ip")
        .send()?;
    std::io::copy(&mut response, &mut stdout()).expect("Failed to read response");
    // let text = response.text()?;
    // println!("{}", text);
    Ok(())
}

#[test]
fn test_nbang_path() -> anyhow::Result<()> {
    let home_dir: PathBuf = dirs::home_dir().unwrap();
    let dbang_home = Path::new(&home_dir).join(".dbang");
    let dbang_exits = dbang_home.exists();
    println!("{}", dbang_exits);
    println!("{}", dbang_home.display());
    // fs::create_dir_all("/some/dir")?;
    Ok(())
}

#[test]
fn test_parse_json_from_file() -> anyhow::Result<()> {
    //let home_dir: String = dirs::home_dir.unwrap();
    //Path::new(&home_dir).join("test.json").join("test.json");
    let path = "./src/input.json";
    let data = fs::read_to_string(path).expect("Unable to read file");
    let res: serde_json::Value = serde_json::from_str(&data).expect("Unable to parse");
    println!("{}", res);
    Ok(())
}
