/// Assert the constant expression evaluate to `true`.
///
/// # Example
///
/// ```
/// # #[macro_use] extern crate datool; fn main() {}
/// const U32SIZE: i32 = 4;
/// static_assert!(U32SIZE == 4);
/// // static_assert!(3 * 3 == 3 + 3); compile fail
/// ```
#[macro_export]
macro_rules! static_assert {
    ($condition: expr) => {
        const _: [(); 0 - !{
            const CONDITION: bool = $condition;
            CONDITION
        } as usize] = [];
    };
}

/// Assert the constants are equal in value.
///
/// # Example
///
/// ```
/// # #[macro_use] extern crate datool; fn main() {}
/// static_assert_eq!(2 + 2, 2 * 2);
/// ```
#[macro_export]
macro_rules! static_assert_eq {
    ($lhs: expr, $rhs: expr) => {
        static_assert!($lhs == $rhs);
    };
}

/// Assert the constants are not equal in value.
///
/// # Example
///
/// ```
/// # #[macro_use] extern crate datool; fn main() {}
/// static_assert_ne!(3 + 3, 3 * 3);
/// ```
#[macro_export]
macro_rules! static_assert_ne {
    ($lhs: expr, $rhs: expr) => {
        static_assert!($lhs != $rhs);
    };
}
