<!-- SPDX-FileCopyrightText: 2021 Lutris Engineering, Inc -->
<!-- SPDX-License-Identifier: BlueOak-1.0.0 OR BSD-2-Clause-Patent -->
<!-- SPDX-FileContributor: Piper McCorkle <piper@lutris.engineering> -->

datom-rs is a project of Lutris Engineering, Inc.

Before you contribute to a Lutris Engineering project, you must sign the
Contributor Certificate of Origin. The CCO simply certifies that you
either own your contribution or have the rights to contribute it under
the project's license.

You can read the CCO on its [wiki page](https://wiki.lutris.engineering/wiki/Contributor_Certificate_of_Origin).
A maintainer will get in touch with you with instructions on how to sign
the CCO if your contribution is accepted into the project.

In addition, you must add an `SPDX-FileContributor` comment to every
file you modify. For example, if your name is John Doe, you contributed
personally (not on behalf of an organization), and your email address is
johndoe@mail.com, you would add the following comment:

```rs
// SPDX-FileContributor: John Doe <johndoe@mail.com>
```

If your name is John Doe, you contributed on behalf of Software Company,
Inc., and your email address is jdoe@software.com, you would add the
following comment:

```rs
// SPDX-FileContributor: Software Company, Inc. / John Doe <jdoe@software.com>
```

If your name is John Doe, you contributed on behalf of Lutris
Engineering, Inc., and your email address is john@lutris.engineering,
you would add the following comment:

```rs
// SPDX-FileContributor: John Doe <john@lutris.engineering>
```

Contributions on behalf of Lutris Engineering are the only contributions
exempt from adding the company's name to the `SPDX-FileContributor`
comment. The `lutris.engineering` email domain name is considered
"well-known" to refer to Lutris Engineering, Inc.
