/*
This file is part of Yama.

Yama is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Yama is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Yama.  If not, see <https://www.gnu.org/licenses/>.
*/


use std::collections::HashMap;
use std::fs::File;
use std::io::Write;
use std::path::Path;

use crate::descriptor::{Descriptor, SourceDescriptor};

pub mod backup;
pub mod extract;
pub mod ibrowse;
pub mod ilabel;

pub fn init_descriptor(path: &Path) -> anyhow::Result<()> {
    std::fs::create_dir_all(path)?;
    std::fs::create_dir(path.join("labelling"))?;

    let mut datman_toml_file = File::create(path.join("datman.toml"))?;

    let source: HashMap<String, SourceDescriptor> = Default::default();
    /*source.insert("demo1".to_owned(), SourceDescriptor::DirectorySource {
        hostname: "demohost1".to_string(),
        directory: PathBuf::from("/dev/null")
    });
    source.insert("demo2".to_owned(), SourceDescriptor::VirtualSource { blah: "".to_string(), label: "wat".to_string() });*/

    let bytes = toml::to_vec(&Descriptor {
        labels: vec![
            "pocket".to_owned(),
            "precious".to_owned(),
            "bulky".to_owned(),
        ],
        source,
        piles: Default::default(),
    })?;

    datman_toml_file.write_all(&bytes)?;

    Ok(())
}
