# datamatrix-rs

[![crates.io](https://img.shields.io/crates/d/datamatrix.svg)](https://crates.io/crates/datamatrix)
[![Documentation](https://docs.rs/datamatrix/badge.svg)](https://docs.rs/datamatrix)
![License](https://img.shields.io/crates/l/datamatrix)
![Lines of Code](https://tokei.rs/b1/github/jannschu/datamatrix-rs?category=code)

Data Matrix (ECC 200) decoding and encoding library with an optimizing encoder.

<p align="center">
  <img src="src/datamatrix-rs.png" alt="Data Matrix encoding 'datamatrix-rs'">
</p>

This library features an optimzing, and linear time encoder which achieves
the smallest possible encoding size.

The Data Matrix standard (ISO/IEC 16022:2006) contains a heuristic to decide
which encoding modes to use, and in most cases that works. A straightforward
implementation will not have linear runtime, though. This library uses an idea
similar to the A\* algorithm.

The optimizer is special about this implementation, most implementations use the
heuristic. See the list of related projects below for credits and references to
other open source Data Matrix libraries.

## Example

```rust
let code = DataMatrix::encode(
    b"Hello, World!",
    SymbolList::default(),
).unwrap();

// print an "ASCII art" version
print!("{}", code.bitmap().unicode());
```

The library contains helpers for generating other output formats. Example code can be found
in `examples/`. The extra effort for this last rendering step is usually low and
this approach allows high flexibility.

## Status

- [x] Encodation modes ASCII, Base256, C40, Text, X12, EDIFACT implemented.
- [x] Optimizer for switching between encodation modes to find a minimal
      encodation size.
- [x] Data part decoding.
- [x] Fuzzed data de- and encoding (*no issues after 48h*)
- [x] Check the open bug reports in other implementations.
- [x] Reed Solomon de-/encoder.
- [x] Tile placement encoding.
- [x] Helpers for rendering
- [x] Implement [Extended Rectangular Data Matrix (DMRE)](https://e-d-c.info/projekte/dmre.html)
  defined in ISO 21471 which adds more rectangular symbol sizes
- [x] Tile placement decoding.
- [ ] Visual detection in images.
- [ ] More detailed decoder output.
- [ ] ECI support. This has progressed as far as I could get without buying the
      standards for this (several hundred dollars).

Things in consideration for after that:

- "Structured Append"
- "Reader Programming"

## Disclaimer

Since the encoded data is padded to fill up the remaining space in a Data Matrix
symbol, the symbol generated by this library will in many cases not be smaller
compared to an optimizer based on the heuristic defined in the specification.
What it achieves however in any case is a linear encoding time, and it avoids
some of the bugs which can be attributed to using the heuristic (see open
bugs in zxing and OkapiBarcode). And, of course, there _are_ cases where it will
return a smaller symbol altough admittedly no thorough study of this has been
done.

## Related projects

The following projects were invaluable for learning from their implementation
and stealing some of their test cases and bug reports.

- [zxing](https://github.com/zxing/zxing) is a Google library to encode
  and decode multiple 1D and 2D codes including Data Matrix. The core part
  is written in Java. It uses the heuristic from the specification.
- [barcode4j](http://barcode4j.sourceforge.net/) is a predecessor (?) of zxing,
  the Data Matrix code was forked into zxing.
- [libdmtx](https://github.com/dmtx/libdmtx) is the most prominent open source
  C library for encoding and decoding Data Matrix. It has a more limited optimizer
  compared to the specification, but it can also decode Data Matric codes from images.
- [zxing-cpp](https://github.com/nu-book/zxing-cpp) is a C++ port of zxing, it
  also contains some improvements.
- [OkapiBarcode](https://github.com/woo-j/OkapiBarcode) is a Java library with
  Data Matrix encoding support, among dozens of other codes! The implementation
  seems to follow the standard.
- OkapiBarcode is ported from (?) the [zint](http://zint.org.uk) C library.
  Ports to Pascal and C# are referenced on their website. Off topic: There
  are encoders for some nice vintage codes and discontinued commercial codes, see "Extras"
  on the website.
- [postscriptbarcode](https://github.com/bwipp/postscriptbarcode) implements encoding of
  several 1D and 2D codes using only PostScript. It is also available as a LaTeX
  package. [Port to JavaScript](https://github.com/metafloor/bwip-js).
- A [perl module](https://github.com/mstratman/Barcode-DataMatrix) for encoding.
- [iec16022](https://github.com/rdoeffinger/iec16022) is a Data Matrix encoder originally
  written by Andrews & Arnold Ltd. but is now maintained by Reimar Döffinger. It has a similar
  optimizing encoder.