//! This is documentation for the `datakind` crate.
//!
//! The functions in this crate take strings and return if those strings
//! look like a datatype.
//!

use lazy_static::lazy_static;
use regex::Regex;

fn is_logical(text: &str) -> bool {
    // col_logical -l, T,F,TRUE,FALSE,True,False,true,false,t,f,1,0
    lazy_static! {
        static ref R: Regex =
            Regex::new(r"^true$|^false$|^t$|^f$|TRUE$|^FALSE$|^T$|^F$|^True|^False|^1$|^0$")
                .unwrap();
    }
    R.is_match(text)
}

#[cfg(test)]
mod tests {
    use super::*;
    #[test]
    fn test_is_logical() {
        assert_eq!(is_logical("True"), true);
    }
}
