#!/usr/bin/env bash

DEV_HOST=http://127.0.0.1:8080
HOST=https://api.criterion.dev
#HOST=$DEV_HOST


CRITERION_TOKEN=abc123

if [[ -z "$CRITERION_TOKEN" ]]; then
    echo "Must provide CRITERION_TOKEN in environment: export CRITERION_TOKEN=\"token\"" 1>&2
    exit 1
fi

# collect required upload parameters
GITHUB_USERNAME=$(echo $(git config --get remote.origin.url) | awk -F'/' '{print $4}')
GITHUB_REPO=$(echo $(git config --get remote.origin.url) | awk -F'/' '{print $5}')
GITHUB_REPO=$(echo ${GITHUB_REPO} | awk -F'.' '{print $1}')
GIT_COMMIT_HASH=$(echo $(git rev-parse HEAD))

# build upload URL for `UPLOAD_COMMAND`
UPLOAD_URL="$HOST/v1/$GITHUB_USERNAME/$GITHUB_REPO/measurements?token=$CRITERION_TOKEN&commit=$GIT_COMMIT_HASH"

# find the criterion files to upload
while IFS= read -r -d '' UPLOAD_FILE_PATH; do
    # only upload files generated by this script
    if [[ "$UPLOAD_FILE_PATH" == *"/new/"* ]]; then
      # build upload command
      UPLOAD_COMMAND="curl -F 'raw.csv=@$UPLOAD_FILE_PATH' '$UPLOAD_URL'"
      echo "uploading: $UPLOAD_FILE_PATH"
      # upload the file
      eval "$UPLOAD_COMMAND"
    fi
done < <(find . -name "raw.csv" -print0)

REPORTS_FILE_NAME="reports.tar.gz"
REPORTS_FILE_PATH="./$REPORTS_FILE_NAME"
REPORTS_UPLOAD_URL="$HOST/v1/$GITHUB_USERNAME/$GITHUB_REPO/reports?token=$CRITERION_TOKEN&commit=$GIT_COMMIT_HASH"
tar -zcvf "$REPORTS_FILE_NAME" -C $(find . -type d -name criterion) .
curl -F "$REPORTS_FILE_NAME=@$REPORTS_FILE_PATH" "$REPORTS_UPLOAD_URL"
rm $REPORTS_FILE_PATH