//! # data struct HashMap Demo
//! The demo using HashMap
use std::collections::HashMap;

fn main() {
  let mut map = HashMap::new(); // 新建空 HashMap
  explain("empty", &map);

  map.insert('a', 1); // 插入操作
  explain("added 1", &map);

  map.insert('b', 2);
  explain("added 2", &map);
  map.insert('c', 3);
  map.insert('d', 4);
  explain("added 4", &map);

  // get 时需要使用引用，并且也返回引用
  assert_eq!(map.get(&'a'), Some(&1));
  assert_eq!(map.get_key_value(&'b'), Some((&'b', &2)));

  // println!("map.get('a'):{:?}, {:?}", map.get(&'a'), Some(1).unwrap());

  map.remove(&'a'); // 删除操作
  explain("removed", &map);

  map.shrink_to_fit(); // shrink 后哈希表变小
  explain("shrinked", &map);
}

/// 打印 hashmap 长度 和 capacity
/// # Example
///```rust
/// let mut map = HashMap::new(); // 新建空 HashMap
/// explain("empty", &map);
///```
/// 自动生成函数签名，这里可以写例子或者其他注释
fn explain<K, V>(name: &str, map: &HashMap<K, V>) {
  println!("{}: len:{}, cap:{}", name, map.len(), map.capacity());
}
